<?php
include ("view/template.php");

class Contact extends Template
{
    function __construct ()
    {
        parent::__construct ("contact", "Contact Us", "");
    }

    function printMainContent()
    {
    ?>
    <div class="full_width">
        <section id="section_main" class="page_container">
            <div class="iparsysmain iparsys parsys">
                <div class="section">
                    <div class="new"></div>
                </div>
                <div class="iparys_inherited">
                    <div class="iparsysmain iparsys parsys"></div>
                </div>
            </div>
            <div class="body_container">
                <div class="leftNav">
                    <a class="a_show_nav_secondary">In this section</a>
                    <nav id="nav_secondary"></nav>
                </div>
                <article id="article_main">
                    <a name="startcontent" id="startcontent"></a>
                    <div class="pageHeader userToolbar"></div>
                    <div class="parCenter parsys">
                        <div class="contactCC section">
                            <header>
                                <a href="#" id="a_main_content" title="Start of main content">Start of main content</a>
                                <h2>Email Yonga & Simiyu</h2>
                            </header>
                            <form name="frm" action="#" method="GET" id="sendEmail">
                                <h3>Please fill in your details below and submit your enquiry.</h3>
                                <p><strong class="utils_magenta">Fields marked * are compulsory</strong></p>
                                <ul id="ul_article_form">
                                    <li class="required">
                                        <label for="nature">Nature of enquiry<strong class="utils_magenta">&nbsp;*</strong></label>
                                        <select id="enquiry_nature" class="fullinput isInvalid" name="enquiry">
                                            <option value="0">Please select</option>
                                            
                                            <option value="Events">Events</option>
                                            
                                            <option value="General enquiry">General enquiry</option>
                                            
                                            <option value="HR general enquiry">HR general enquiry</option>
                                            
                                            <option value="Invoices &amp; billing">Invoices &amp; billing</option>
                                            
                                            <option value="Legal services">Legal services</option>
                                            
                                            <option value="Media enquiry">Media enquiry</option>
                                            
                                            <option value="Pro bono &amp; community outreach">Pro bono &amp; community outreach</option>
                                            
                                            <option value="Process agent services">Process agent services</option>
                                            
                                            <option value="Recruitment &amp; work experience">Recruitment &amp; work experience</option>
                                            
                                            <option value="Report a broken link or problem with our site">Report a broken link or problem with our site</option>
                                            
                                            <option value="Report fraud">Report fraud</option>
                                            
                                            <option value="Request anti-corruption information">Request anti-corruption information</option>
                                            
                                            <option value="Thought leadership">Thought leadership</option>
                                        </select>
                                    </li>
                                    <li class="li_error pageColour_bg utils_white" id="enq-error">Please select the nature of your enquiry</li>
                                    <li>
                                        <label for="comments">Message</label>
                                        <textarea id="comments" name="fullinput"></textarea>
                                    </li>
                                    <li class="" id="words">This message contains profanity.</li>
                                    <li class="required">
                                        <label for="firstname">First name<strong class="utils_magenta">&nbsp;*</strong></label>
                                        <input id="firstname" type="text" name="firstname" class="isInvalid" required>
                                    </li>
                                    <li class="li_error pageColour_bg utils_white">Please tell us your First name</li>
                                    <li class="required">
                                        <label for="lastname">Last name<strong class="utils_magenta">&nbsp;*</strong></label>
                                        <input id="lastname" type="text" name="lastname" class="isInvalid" required>
                                    </li>
                                    <li class="li_error pageColour_bg utils_white">Please tell us your Last name</li>                                    
                                    <li>
                                        <label for="role">Job Title</label>
                                        <input id="role" type="text" name="role" class="halfinput">
                                    </li>                        
                                    <li class="required">
                                        <label for="emailaddress">Email address<strong class="utils_magenta">&nbsp;*</strong></label>
                                        <input id="emailaddress" type="text" name="emailaddress" class="isInvalid" required>
                                    </li>
                                    <li class="li_error pageColour_bg utils_white" id="email-error">Please input a valid Email address</li>
                                    <li>
                                        <label for="phone">Phone number</label>
                                        <input id="phone" type="text" name="phonee" class="fullinput">
                                    </li>
                                    <li class="li_error pageColour_bg utils_white" id="phone-error"></li>
                                    <li>
                                        <label for="firmname">Organisation name</label>
                                        <input id="firmname" type="text" name="orgname" class="fullinput">
                                    </li>
                                        
                                    <li>
                                        <input type="submit" id="submitContact" value = "SUBMIT" style="color: #fff; background-color: #bd8620; text-align: centre; width: 100%;">
                                        <p id="enquiry-success" style="color: #0e8af3;"></p>
                                    </li>
                                </ul>
                                <p><b>Yonga & Simiyu will only process your personal data in relation to this specific enquiry.</b></p>
                            </form>
                            <section id="section_thankyou" class="pageColour_bg">
                                <h2>Thank you</h2>
                                <h3>
                                    <p>Thank you for contacting Yonga & Simiyu.&nbsp;We will review and respond to your query as soon as possible.&nbsp;</p>
                                </h3>
                            </section>
                        </div>
                    </div>
                </article>

                <?php $this->printShareShow(); ?>

                <aside id="aside_main">
                    <div class="parRight parsys">
                        <!-- <div class="imageAndTextLink section">
                            <div class="a_image_text_link_pod">
                                <h2 style="padding-left: 10px !important;">Have you received a suspicious email or letter? </h2>
                                <p>Read our guidance on scam emails and letters on our Fraud alert</p>
                            </div>
                        </div>
                        <div class="imageAndTextLink section">
                            <a class="a_image_text_link_pod" href="careers.php" target="_blank">
                                <h2 style="padding-left: 10px !important;">Work experience and speculative applications</h2>
                                <p>If you wish to contact an Advocate at the firm regarding a work experience placement or to make an application, you may not receive a response. All the firm's vacancies are advertised in one place.
                                <br>Search and apply for current opportunities at <ins>yongaandsimiyu.com/careers.php</ins></p>
                            </a>
                        </div> -->
                        <div class="imageAndTextLink section">
                            <div class="a_image_text_link_pod">
                                <h2 style="padding-left: 10px !important;">Do you wish to talk to an advocate directly? </h2>
                                <p><strong style = "color: #bd8620">Visit:</strong>&nbsp;&nbsp;&nbsp;MNG Apartments, Ndemi Road -<br><span style="margin-left: 47px;">Kilimani, Nairobi</span></p>
                                <p><strong style = "color: #bd8620">Email:</strong> <a href = "mailto:advocates@yongaandsimiyu.com" style="font-size: 14px;">advocates@yongaandsimiyu.com</a></p>
                                <p><strong style = "color: #bd8620">Phone:</strong> <a href = "tel:+254796116510">Call Yonga & Simiyu</a></p>
                            </div>
                        </div>
                    </div>
                </aside>
                <!-- Script for Schema markup -->
                <script>

                let text = document.location.href;
                let result = text.substring(text.indexOf('.com')+5,text.indexOf('.html'));
                console.log(result);
                const nameArr = result.split("/").reverse();
                console.log(nameArr);
                var indices = [];
                for(var i=0; i<result.length;i++) {
                    if (result[i] === "/") indices.push(i);
                }
                var revIndices=indices.reverse();
                var itemArr=[];
                itemArr.push(text);
                for(var i=0; i<indices.length;i++) {
                    itemArr.push(document.location.protocol +"//"+document.location.host+"/"+result.substring(0,revIndices[i])+'.html');
                }
                console.log(itemArr);
                    
                    var bschema = {
                        "@context": "https://schema.org/", 
                "@type": "BreadcrumbList", 
                "itemListElement": []
                    }   
                    for(var i=0; i<nameArr.length; i++)  {
                    bschema.itemListElement.push({"@type":"ListItem","position":i, "name":nameArr[i], "item": itemArr[i]});
                }
                    var bscript = document.createElement('script');
                        bscript.type = "application/ld+json";
                        bscript.text = JSON.stringify(bschema);

                        document.querySelector('head').appendChild(bscript);

                </script>
                <!-- Script for Schema markup end -->
            </div>
        </section>
    </div>
    <?php
    }

    function printPageStyle ()
    {
    ?>
    <style type="text/css">
   	.pageColour_text {
        color: #FFFFFF !important;
    }
    .pageColour_bg {
    	background-color: #FFFFFF !important;
    }
    header#header_main nav ul li a:hover {
		color: #FFFFFF;
    }
    header#header_main nav ul li.selected a {
		color: #FFFFFF !important;
    }

    header#header_main_microsite nav#nav_primary > ul > li.selected {
        background-image: url(/etc/designs/cc2014/images/dynamic-microsite/FFFFFF_arrow.png);
    }
    
    @media only screen and (-webkit-min-device-pixel-ratio: 1.5), only screen and (-o-min-device-pixel-ratio: 3/2), only screen and (min--moz-device-pixel-ratio: 1.5), only screen and (max-width: 480px), only screen and (min-device-pixel-ratio: 1.5) {
        header#header_main_microsite nav#nav_primary > ul > li.selected {
            background-image: url(/etc/designs/cc2014/images/dynamic-microsite/FFFFFF_arrow@2x.png);
        }
    }
    </style>
    <?php
    }
}
$contact = new Contact;
$contact->printPage();
?>