
// JavaScript Document

var sColour = '#30AFA4';
var returnColour = '#000000';
var bIsMoving = false;
var sRegionSelected = 'worldmap';
// Burnable boolean value to take note if the trigger came came a children children menu (i.e. a menu option in the coloured sub drop down from the children 
// menu was selected and the page was changed rather than the article_section_children_visible content being changed with JQuery). This stops the problem where
// a sub sub menu would display the content from its parent because the parent's click is being triggered to make it look selected.
var bSubSubTrigger = false;


$(document).ready( function() {

	$('a#a_tkosp_button').css({'border-width' : '0px'});

    /*
	$('body.body_micro a#a_tkosp_button').click( function() {
		$('a#a_tkosp_button').css({'border-width' : '0px'});
		openCloseTKOSP();
		return false;
	});
	*/

	sColour = $('body').data('customcolour');

	$('a#show_search').click( function(e) {
		$('header#header_main > form.form_search').slideToggle();
		e.preventDefault();
	});

	$('#a_load_video').click( function(e) {
		loadVideo();
		e.preventDefault();
	});
	
	$('.a_children_menu_item').click( function(e, isFromTrigger) {
		switchChildren($(this), isFromTrigger);
		e.preventDefault();
	});

	$('li.li_sharing_print').click( function() {
			window.print();
			return false;
		});
	
	$('#section_article_accordion article section, .section_article_accordion article section').not('.section_accordion_nohide').hide();

	$('article#article_main').on('click', '#section_article_accordion article h1 a, .section_article_accordion article h1 a, #section_article_accordion article h4 a, .section_article_accordion article h4 a', function(e) {
		toggleAccordion($(this));
		e.preventDefault();
	});
	
	$('iframe').on("load", function() {
		//alert('loaded');
		$(this).slideDown();	
	});
	
	// Add an empty article to the children section so we can reload it with content
	$('section#section_article_children').prepend('<article id="article_section_children_visible"></article>');
	
	animateOffice();

    /*
	$('header#header_main nav ul li a').hover(
		function() {
			if ($(this).attr('id') == 'nav_zone1_0') {
				$(this).css({'background-color': '#' + sColour});
			} else {
				$(this).css({'color': '#' + sColour});
			}
		},
		function() {
			if ($(this).attr('id') == 'nav_zone1_0') {
				$(this).css({'background-color': '#000000'});
			} else {
				$(this).css({'color': '#000000' });
			}
		}
	);
    */
	
	
	// Loop over any children menu items and...
	$('.a_children_menu_item').each( function(i) {
		// ...send their data id to a clas of the block quote
		$('#section_aside_blockquotes blockquote:nth-child(' + (i + 2) + ')').addClass($(this).data('thisuid'));
		
	});
	
	// -------------------------------------------------------------------------------------
	// Child menu control in the centre article under the image
	// -------------------------------------------------------------------------------------
	
	$('nav#nav_article_children').on('click', 'a#a_article_children_right', function(e) {
		if (!bIsMoving) {
			if ($('.li_first_visible').next().length > 0) {
				bIsMoving = true;
				var position = $('.li_first_visible').next().position();
				var positionCurrent = 0;
				if ($('.li_selected').length > 0 ) {
					positionCurrent = $('.li_selected').position();
				}

				$('ul.ul_article_children_children').animate({ 'background-position-x': '-' + parseInt(position.left - 30) - (2500 - positionCurrent.left) + ($('.li_selected').outerWidth(true) / 2) + 'px' }, 500);
				
				$('nav#nav_article_children ul#ul_article_children').animate( {'margin-left': '-' + parseInt(position.left - 30) + 'px'}, 500, function() {
					$('.li_first_visible').removeClass('li_first_visible').next().addClass('li_first_visible');
					evalTransportControls();
					$('a#a_article_children_left').animate({'opacity': '1'});
					
					//$('ul.ul_article_children_children').attr('data-xpos', xPos);
					
					bIsMoving = false;
				});
			}
		}
		e.preventDefault();
	});
	
	$('nav#nav_article_children').on('click', 'a#a_article_children_left', function(e) {
		if (!bIsMoving) {
			if ($('.li_first_visible').prev().length > 0) {
				bIsMoving = true;
				var position = $('.li_first_visible').prev().position();
				var positionCurrent = 0;
				if ($('.li_selected').length > 0 ) {
					positionCurrent = $('.li_selected').position();
				}
				$('ul.ul_article_children_children').animate({ 'background-position-x': '-' + parseInt(position.left - 30) - (2500 - positionCurrent.left) + ($('.li_selected').outerWidth(true) / 2) + 'px' }, 500);
				
				$('nav#nav_article_children ul#ul_article_children').animate( {'margin-left': '+=' + parseInt($('.li_first_visible').prev().outerWidth(true)) + 'px'}, 500, function() {
					$('.li_first_visible').removeClass('li_first_visible').prev().addClass('li_first_visible');
					evalTransportControls();
					$('a#a_article_children_right').animate({'opacity': '1'});
					bIsMoving = false;
				});
			}
		}
		e.preventDefault();
	});
	
	// -------------------------------------------------------------------------------------
	// Multiple language control
	// -------------------------------------------------------------------------------------
	
	// Let's hide any additional languages
	$('.section_language_tab').not('.section_language_tab_base').hide();

    // And assign functionality to the language tabs
	$('.ul_language_tabs').on('click', 'li a', function(e) {
		// This button
		var thisButton = $(this);
		// Loop over the language sections and find a match
		$('.section_language_tab').each( function() {
			if ($(this).attr('lang') == thisButton.attr('hreflang')) {
                $(this).slideDown( function() {

					// Set the background selector to centre on the first visible tab
                    var thisUL = $(this).find('ul.ul_article_greytabs_generic');
                    // alert(thisUL.children('li:first-child').text());
                    if ($(this).find('ul.ul_article_greytabs_generic').length > 0) {
                    	thisUL.animate({'background-position' : (thisUL.children('li:first-child').position().left - 1000) + (thisUL.children('li:first').width() / 2) + 'px'});
                    }
                    // $(this).find('ul.ul_article_greytabs_generic').animate({'background-position' : '300px'});
                });
				// Save the current content of the H1 and H3
				var sH3 = $(this).find('h3.h3_multilanguagetitle').text();
				var sH4 = $(this).find('h4.h4_multilanguagetitle').text();
				// Swap them over (if there is one)
				if (sH3 != '') {
					$('article#article_main header h2').fadeOut(200, function() {
						$('article#article_main header h2').text(sH3);
						$('article#article_main header h2').fadeIn(200);
					});

				}
				if (sH4 != '') {
					$('article#article_main header h3').fadeOut(200, function() {
						$('article#article_main header h3').text(sH4);
						$('article#article_main header h3').fadeIn(200);
					});

				}
			} else {
				$(this).slideUp();
			}
		});
		if (thisButton.attr('hreflang') == 'en') {
			// Show the main English accordion
			$('section.section_article_accordion_base').slideDown();
		} else {
			// Hide the main English accordion
			$('section.section_article_accordion_base').slideUp();	
		}
        // Set the names
		$('.section_language_names').each( function() {
			if ($(this).attr('lang') == thisButton.attr('hreflang')) {
                var sTransText = $(this).text();
                $('div#header_h2_h3 h2').fadeOut( function() {
					$('div#header_h2_h3 h2').text(sTransText);
                    $('div#header_h2_h3 h2').fadeIn();
                });

            }
        });
        // Set the job title
		$('.section_language_title').each( function() {
			if ($(this).attr('lang') == thisButton.attr('hreflang')) {
                var sTransText = $(this).text();
                $('div#header_h2_h3 h3').fadeOut( function() {
					$('div#header_h2_h3 h3').text(sTransText);
                    $('div#header_h2_h3 h3').fadeIn();
                });

            }
        });
		// Mark as selected
		$('.ul_language_tabs li a').removeClass('pageColour_bg');
		thisButton.addClass('pageColour_bg');
		e.preventDefault();
	});
	
	// -------------------------------------------------------------------------------------
	// Horizontal grey tab navigation control
	// -------------------------------------------------------------------------------------

	// Let's hide all results sections
	$('.section_tab_nav').hide();
	
	// And assign functionality to the grey tabs
	$('.a_tab_nav').click( function(e) {
		// This button
		var thisButton = $(this);
		// Loop over the content sections and find a match
		$('.section_tab_nav').each( function() {
			if ($(this).data('parenttab') == thisButton.attr('id')) {
				$(this).slideDown();
			} else {
				$(this).slideUp();
			}
		});
		// Mark as selected
		$('.a_tab_nav').removeClass('pageColour_bg');
		$('.a_tab_nav').removeClass('utils_white');
		$('.a_tab_nav').children().removeClass('utils_white');
		thisButton.addClass('pageColour_bg');
		thisButton.addClass('utils_white');
		thisButton.children().addClass('utils_white');
		e.preventDefault();
	});
	
	// -------------------------------------------------------------------------------------
	// Hide and create rollover state for overflowing tag lists
	// -------------------------------------------------------------------------------------
	
	// Get the number of extra tags
	var nExtraTags = $('.span_tag_overflow').length;
	var sTitleTags = "";
	// Then hide them
	$('.span_tag_overflow').hide();
	
	// Loop over the class="span_tag_overflow" elements to count and structure them
	$('.span_tag_overflow').each( function() {
		sTitleTags += $(this).text();
	});
	
	if (nExtraTags > 0) {
		$('.span_tag_overflow_first').after(' <a class="pageColour_text" href="#" title="' + sTitleTags + '">(+' + nExtraTags + ' more)</a>');
	}
	
	/*
	
	// -------------------------------------------------------------------------------------
	// Standard grey tab initialisation
	// -------------------------------------------------------------------------------------
	
	// Start by data marking all the corresponding tabs and their targets
	$('section#section_tabbed_content ul#ul_article_greytabs').each( function() {
		$(this).find('li a').each( function(i) {
			$(this).addClass('tab_' + i);
		});
		$(this).parent().find('article.article_greytabs').each( function(i) {
			$(this).addClass('tab_' + i);
			// Hide the articles we don't need in the first view
			if (i > 0) {
				$(this).hide();	
			}
		});
		$(this).after('<img class="img_up_arrow_generic" src="/etc/designs/cc/images/arrow_up_generic.png" width="30" height="15" alt="" />');
		$(this).next().animate({
			'margin-left': (($(this).children('li:first-child').position().left + ($(this).children('li:first-child').width() / 2)) - 15) + 'px'
		});
	});
	
	// Start by data marking all the corresponding aside tabs and their targets
	$('section.section_tabbed_content ul.ul_article_greytabs li a').each( function(i) {
		$(this).addClass('tab_' + i);
	});
	$('section.section_tabbed_content article.article_greytabs').each( function(i) {
		$(this).addClass('tab_' + i);
		// Hide the articles we don't need in the first view
		if (i > 0) {
			$(this).hide();	
		}
	});
	
	// Give the tabs some click functionality
	$('section#section_tabbed_content ul#ul_article_greytabs li a').click( function(e) {
		
		$(this).parent().parent().next().animate({
			'margin-left': (($(this).parent().position().left + ($(this).parent().width() / 2)) - 15) + 'px'
		});
		
		$(this).parent().parent().parent().find('article.article_greytabs').slideUp();
		$(this).parent().parent().parent().find('article.' + $(this).attr('class')).slideDown();
		
		if ($(this).parent().hasClass('activeTab')) {
			$(this).parent().parent().animate({'background-position' : '-255px'});
		} else {
			$(this).parent().parent().animate({'background-position' : '-70px'});
		}
		e.preventDefault();
		
	});
	
	// Give the aside tabs some click functionality
	$('section.section_tabbed_content ul.ul_article_greytabs li a').click( function(e) {
		
		$('section.section_tabbed_content article.article_greytabs').slideUp();
		$('section.section_tabbed_content article.' + $(this).attr('class')).slideDown();
		
		if ($(this).parent().hasClass('activeTab')) {
			//alert('yes');
			$(this).parent().parent().animate({'background-position' : '-255px'});
		} else {
			$(this).parent().parent().animate({'background-position' : '-70px'});
			//alert('no');
		}
		e.preventDefault();
		
	});
	
	*/
	
	// -------------------------------------------------------------------------------------
	// Look for standard res people images and @2x them if we're retina
	// -------------------------------------------------------------------------------------
	
	if (window.devicePixelRatio > 1) {
		if ($('section.section_profile_image').length == 1) {
			var sHiResImageMAIN = $('section.section_profile_image').css('background-image');
			if (sHiResImageMAIN.indexOf('.png') > -1) {
				sHiResImageMAIN = sHiResImageMAIN.split('.png')[0];
				sHiResImageMAIN = sHiResImageMAIN + '@2x.png';
				$('section.section_profile_image').css({'background-image': sHiResImageMAIN});
			}
		}
		$('section.section_aside_contact').each( function() {
			var sHiResImageASIDE = $(this).css('background-image');
			if (sHiResImageASIDE.indexOf('.png') > -1) {
				sHiResImageASIDE = sHiResImageASIDE.split('.png')[0];
				sHiResImageASIDE = sHiResImageASIDE + '@2x.png';
				$(this).css({'background-image': sHiResImageASIDE});
			}
		});
	}
	
	// -------------------------------------------------------------------------------------
	// Initial state of experts pod
	// -------------------------------------------------------------------------------------
	
	$('section.section_aside_contacts_list_hcarrier').each( function() {
		if ($(this).data('thisiteration') > 0) {
			$(this).slideUp();
		}
	});

	// ======================================================================
	// SUBMIT PEOPLE SEARCH FORMS TO PEOPLE RESULT PAGE
	// ======================================================================
		
	$('form#form_search_find_person input#con_Submit_find_person').click( function(e) {
		var sname = $(this).parent().find('input#peoplesearchformQuery').val();
		window.location = $(this).parent().attr('action') + '?query=' + sname;
		e.preventDefault();
	});
	
	// -------------------------------------------------------------------------------------
	// Initial state of find a person pod
	// -------------------------------------------------------------------------------------
	
	var bFoundMenuMatch = false;
	var sNameOfPageOrParent = $.trim($('nav#nav_secondary .selected').text());
	
	bFoundMenuMatch = preselectFindPeopleSector(sNameOfPageOrParent);
	
	if (!bFoundMenuMatch) {
		sNameOfPageOrParent = $.trim($('nav#nav_secondary .selected').parent().parent().prev().text());
		bFoundMenuMatch = preselectFindPeopleSector(sNameOfPageOrParent);
	}
	
	// -------------------------------------------------------------------------------------
	// Initial state of accordion component
	// -------------------------------------------------------------------------------------

	$('.section_article_accordion').each( function() {
		var n = parseInt($(this).data('preselection'));
		if (n > 0) {
			$(this).children('article:nth-child(' + n + ')').children('h1').children('a').trigger('click');
			$(this).children('article:nth-child(' + n + ')').children('h4').children('a').trigger('click');
		}
	});

	// -------------------------------------------------------------------------------------
	// Set dupliacte contact OMP pod status
	// -------------------------------------------------------------------------------------
	
	var aOMPNames = [];
	
	$('section#section_aside_omps article').each( function() {
		if ($.inArray($(this).children('h1').text(), aOMPNames) > -1) {
			$(this).addClass('article_omp_duplicate');
		} else {
			aOMPNames.push($(this).children('h1').text());
			$(this).attr('data-ompfirst', $(this).children('h1').text());
		}
		$(this).attr('data-ompname', $(this).children('h1').text());
	});
	
	$('section#section_aside_omps article').each( function() {
		var eOuter = $(this);
		if (eOuter.hasClass('article_omp_duplicate')) {
			$('section#section_aside_omps article').each( function() {
				if (eOuter.data('ompname') == $(this).data('ompfirst')) {
					eOuter.children('address').clone().addClass('cloned_address').appendTo($(this));
				}
				
			});
		}
		
	});
	
	// -------------------------------------------------------------------------------------
	// Set up hover states of sharing tools
	// -------------------------------------------------------------------------------------
	
	var sThisSharingColour = '#41a5d8';
	
	$('li.li_sharing ul li a').hover(
		function() {
			$(this).animate({ 'background-color': sThisSharingColour });
		},
		function() {
			$(this).animate({ 'background-color': '#999999' });
		}
	);

});

$(window).on("load", function() {
	
	// -------------------------------------------------------------------------------------
	// Tie the blockquotes to their parent menu selection item and tweak the height of the container
	// -------------------------------------------------------------------------------------
	
	$('#section_aside_blockquotes').css('height', $('#section_aside_blockquotes blockquote:nth-child(1)').outerHeight());
	
	//alert($('article#article_main h1').outerHeight() + $('article#article_main h2').outerHeight());

	// -------------------------------------------------------------------------------------
	// Get the hash url extention and use it to mark a target child menu item as selected
	// -------------------------------------------------------------------------------------
	
	if (document.location.hash) {
		// Loop over the children menu items
		$('nav#nav_article_children > ul#ul_article_children > li > a').each( function() {
			if ($(this).attr('href') == document.location.hash.split('#')[1]) {
				$(this).addClass('selected');
			}
		});
		// Look for a language extension on the main body
		$('ul.ul_language_tabs > li > a').each( function() {
			if ($(this).attr('hreflang') == document.location.hash.split('#')[1]) {
				$(this).trigger('click');
			}
		});	
	}
	
	// Open the correct tab on load
	// $('a#' + document.location.hash.split('#')[1] + 'Tab').trigger('click');
	
	// -------------------------------------------------------------------------------------
	// Funtionality to control scrolling of children menus
	// -------------------------------------------------------------------------------------
	
	// Check if we actually need to show transport controls
	var nWidthOfMenu = 0;
	
	$('nav#nav_article_children > ul#ul_article_children > li').each( function() {
		nWidthOfMenu += $(this).outerWidth(true, true);
	});
	
	// If the width of the child menu items exceeds the available width in the menu...
	if (nWidthOfMenu > 420) {
		
		// Fade in the transport controls if we do need them
		$('a#a_article_children_left').css({'display': 'block', 'opacity': '0'});
		// $('a#a_article_children_left').animate({'opacity': '0.5'}, 500);
		$('a#a_article_children_right').fadeIn();
		
		// Now look for a pre-selection request by seeing if the servlet has found a match and marked it 'selected'
		if ($('ul#ul_article_children li a.selected').length == 1) {
			
			// Trigger a menu match if we are in a child page or child child page
			$('ul#ul_article_children li a.selected').trigger('click', true);
			// $('ul#ul_article_children li a.selected').parent().addClass('li_first_visible');
		
		// If there is no pre-selction, we should simply make the menu appear range left in the grey bar
		} else {
			
			// Set initial position of list carrier to be effectively left aligned
			$('nav#nav_article_children ul#ul_article_children').animate( {'margin-left': parseInt(-2270 + parseInt((nWidthOfMenu - 460) / 2) + 30) + 'px'}, 1000);
			// We can safely add li_first_visible because nothing is selcted and the menu will work like normal
			$('nav#nav_article_children > ul#ul_article_children > li:first-child').addClass('li_first_visible');
			
		}
		
	// If all menu items are in view without scrolling
	} else {
		
		// Look for a pre-selection request by seeing if the servlet has found a match and marked it 'selected'
		$('ul#ul_article_children li a.selected').trigger('click', true);
		
	}

    // Move the office pod to the cortrect position
    $('aside#aside_main section.section_office_aside').animate({
        'margin-top' : $('article#article_main header').outerHeight(true) + 'px',
        'height': parseInt($('article#article_main section.section_profile_image').outerHeight(true) - 40) + 'px'
    }, 1000);

    // Position the aside of the microsite template
    $('section.section_main_microsite aside').css({'margin-bottom':'15px', 'top': $('article#article_main header').outerHeight(true) + 20 + 'px', 'min-height': $('article#article_main header').outerHeight(true) + $('aside#aside_main div.findPeople').outerHeight(true) + 'px'});

});

function switchChildren(thisElement, isFromTrigger) {
	
	//Fade out H1 and swap the text for the clicked element's text, then fade H1 back in
	if ($('ul.ul_article_children_children li').children('a').hasClass('selected')) {
		//alert('yes');
	} else {
		$('article#article_main header h1').fadeOut(500, function() {
			$(this).text(thisElement.text());
			$('article#article_main header h1').fadeIn(500);
			articleHeaderHeight = parseInt($('article#article_main').css('padding-top')) + $('article#article_main header').outerHeight(true) - 40;
			$('aside#aside_main').css({'padding-top' : articleHeaderHeight + 'px'});
		});
	}
	
	// Pre-select find people office menu
	preselectFindPeopleOffice(thisElement.text());
	
	// Call external function to switch the contacts
	switchContacts(thisElement, isFromTrigger);
	
	// Check the width of the menu items
	var nWidthOfMenu = 0;
	$('nav#nav_article_children > ul#ul_article_children > li').each( function() {
		nWidthOfMenu += $(this).outerWidth(true, true);
	});
	
	// Slide up the main visible article so we don't see the swap of content
	$('#article_section_children_visible').slideUp( function() {
		// Loop over the children article holders
		$('section#section_article_children article.article_section_children_holders').each( function() {
			// Look for the article that matches the data id of the clicked button...
			if ($(this).data('thisuid') == thisElement.data('thisuid')) {
				// Check if a sub sub menu with a selected state exists...
				if ($(this).find('ul.ul_article_children_children li a.selected').length > 0) {
					bSubSubTrigger = true;
				}
				// ...switch the inner HTML of the main article
				$('#article_section_children_visible').html($(this).html());
				// But, if we have a sub sub trigger, we have to hide the content from the parent page
				if (bSubSubTrigger) {
					$('#article_section_children_visible ul.ul_article_children_children').nextAll().hide();
				}
				// Get the position of the button we've clicked
				var position = thisElement.position();
				// Check if the button we've clicked is out of view
				if (nWidthOfMenu > 420) {
					// Set initial position of list carrier to be effectively left aligned against the button we've selected
					$('nav#nav_article_children ul#ul_article_children').animate( {'margin-left': '-' + parseInt(position.left - 30) + 'px'}, 500, function() {
						// Add the li_first_visible class to the clicked button so the transport controls can pick it up (but remove it from everything else first)
						$('#ul_article_children li.li_first_visible').removeClass('li_first_visible');
						thisElement.parent().addClass('li_first_visible');
						$('#ul_article_children li').removeClass('li_selected');
						thisElement.parent().addClass('li_selected');
						evalTransportControls();
						// CSS the selector to point to the selected button in the coloured ul sub menu
						$('ul.ul_article_children_children').css({ 'background-position-x': (position.left + parseInt($('#ul_article_children').css('margin-left')) + parseInt(thisElement.outerWidth() / 2)) - 2500 + 'px' });
						
						//alert($('ul.ul_article_children_children').css('background-position-x'));
						// Now show the main section because all the data is loaded and the selectors are in the right place
						if (!isFromTrigger) {
							$('.ul_article_children_children').nextAll().not($('header')).slideDown();
						}
						$('#article_section_children_visible').slideDown( function() {
							bSubSubTrigger = false;	
						});
					});
				} else {
					// CSS the selector to point to the selected button in the coloured ul sub menu
					$('ul.ul_article_children_children').css({ 'background-position-x': (position.left + parseInt($('#ul_article_children').css('margin-left')) + parseInt(thisElement.outerWidth() / 2)) - 2500 + 'px' });
					// Now show the main section because all the data is loaded and the selectors are in the right place
					if (!isFromTrigger) {
						$('.ul_article_children_children').nextAll().not($('header')).slideDown();
					}
					$('#article_section_children_visible').slideDown( function() {
						bSubSubTrigger = false;	
					});	
				}
				
				/* Should this actually be here?
				$('.section_aside_contact').animate({
					'background-position-x': '0px',
					'padding-left': '140px',
					'padding-right': '0px'
				}, 500, function() {
					// Do less	
				});
				*/
				
			}
			
			// Loop over the aside addresses to find the one we need to hide and the ones we need to show
			$('.article_aside_address').each( function() {
				
				var thisOffice = $(this);
				
				// alert(thisOffice.data('thisuid') + ' v ' + thisElement.data('thisuid'));
				
				if (thisOffice.data('thisuid') != thisElement.data('thisuid')) {
					thisOffice.slideUp('slow');
				} else {
					thisOffice.slideDown('slow');
					/*
					thisOffice.children('.p_contact_link').slideUp();
					thisOffice.children('.p_contact_link').next().animate({
						'margin-top': '10px'
					}, 500, function() { 
						thisOffice.children('.p_image_box').animate({'width': '0px', 'height': '0px', 'margin-right': '0px'});
					});
					*/
				}
			});
			
			$('.cloned_address').slideUp();
			
		});
		
		// Change the image in the marquee
		$('section#section_article_marquee ul').animate({
			'top': (thisElement.data('thisiteration') + 1) * -200 + 'px'
		}, 500);
		
		// Check if the call came from a genuine click rather than a automatic trigger
		// if (!isFromTrigger) {
			
			// Check if there is more than one contact...
			if ($('section.section_aside_contacts_container').children().length > 1) {
				
				// ... we must move them to show the correct one
				$('section.section_aside_contacts_container section.section_aside_contacts_hcarrier:first-child').animate({
					'margin-top': (thisElement.data('thisiteration') + 1) * -200 + 'px'
				}, 500);
				// And hide all the thumbs we don't need
				$('section#section_aside_contacts_list section.section_aside_contacts_list_hcarrier').each( function() {
					if ($(this).data('thisiteration') == thisElement.data('thisiteration') + 1) {
						if ($(this).children().length > 1) {
							$(this).slideDown();
						} else {
							$(this).slideUp();
						}
					} else {
						$(this).slideUp();
					}
				});
				
			}
			
			// And show the right quote too
			$('aside#aside_main section#section_aside_blockquotes').not('aside#aside_main section.blockquote_simple').animate({
				'margin-left': (thisElement.data('thisiteration') + 1) * -310 + 'px',
				'height': $('.' + thisElement.data('thisuid')).outerHeight() + 'px'
			}, 500);
			// And the right client highlight
			$('aside#aside_main section#section_aside_clienthighlights').animate({
				'margin-left': (thisElement.data('thisiteration') + 1) * -310 + 'px'
			}, 500);

			if (!bSubSubTrigger) {
				$('#section_article_children').nextAll().slideUp();
				$('.h3_article_children_children').animate({'padding-top': '20px'});
			}

			/*
			
		} else {
		
			// Hide the main content of the page
			$('.ul_article_children_children').nextAll().slideUp();
			$('#h3_article_children_children').animate({'padding-top': '0px'});
			
		}
		
		*/
		
	});
		
}

function evalTransportControls() {

	if ($('.li_first_visible').next().length == 0) {
		$('a#a_article_children_right').animate({'opacity': '0.0'}, 200);	
	} else {
		$('a#a_article_children_right').animate({'opacity': '1.0'}, 200);	
	}
	
	if ($('.li_first_visible').prev().length == 0) {
		$('a#a_article_children_left').animate({'opacity': '0.0'}, 200);	
	} else {
		$('a#a_article_children_left').animate({'opacity': '1.0'}, 200);	
	}
	
}

function toggleAccordion(thisElement) {
	
	/*$('#section_article_accordion article section').not(thisElement.parent().next()).slideUp(500);
	$('#section_article_accordion article h1 a').not(thisElement).stop().animate({
		'background-position-x': '-460px'
	}, 500);*/
	
	if (thisElement.hasClass('accordion_selected')) {
		thisElement.parent().next().slideUp(500);
		thisElement.stop().animate({
			'background-position-x': '-460px'
		}, 500);
		thisElement.removeClass('accordion_selected');
	} else {
		thisElement.addClass('accordion_selected');
		thisElement.parent().next().slideDown(500);
		thisElement.stop().animate({
			'background-position-x': '0px'
		}, 500);
	}
};

function loadVideo() {
	
	$('.article_aside_contact').animate({
		'background-position-y': '180px'
	}, 1000, function() {
		// Do less
	});	
	
	$('.section_aside_contact').animate({
		'background-position-x': '-280px',
		'padding-left': '0px',
		'padding-right': '140px'
	}, 1000, function() {
		// Do less
	});
	
	$('#img_marquee_first').animate({
		'left': '-460px'
	}, 1000, function() {
		// Do less
	});
	
	$('#img_marquee_video_still').animate({
		'left': '0px'
	}, 1000, function() {
		$('#section_article_marquee').animate({
			'height': '270px'
		}, 500, function() {
			// Do less	
		});
		$('.section_aside_contact').animate({
			'height': '97px'
		}, 500, function() {
			// Do less	
		});
		$('.article_aside_contact').animate({
			'height': '113px'
		}, 500, function() {
			// Do less	
		});
		$('#article_section_children_visible').slideUp(500);
	});
		
}

function switchContacts(thisElement, isFromTrigger) {
	
	$('.section_aside_contact').animate({
		'height': '184px'
	}, 500, function() {
		// Do less	
	});
	
	$('.article_aside_contact').animate({
		'height': '200px'
	}, 500, function() {
		// Do less	
	});
	
}

function animateOffice() {
    /*
	$('#h1_profile_office a').animate({
		'background-position-x': '-180px'
	}, 20000, function() {
		$('#h1_profile_office a').animate({
			'background-position-x': '0px'
		}, 20000, function() {
			animateOffice();	
		});		
	});
    */
}

// -------------------------------------------------------------------------------------
// Email constructor
// -------------------------------------------------------------------------------------
	
function emailMe(sFN) {
	
	_gaq.push(['_trackEvent', 'PEOPLE-PROFILE', 'Untracked User', 'Send Email: ' + sFN]);
	window.location = 'mailto:' + sFN + '@cliffordchance.com?subject=Clifford%20Chance%20website%20enquiry';
		
};


function emailmecavenagh(sFN) {
	window.location = 'mailto:' + sFN + '?subject=Cavenagh%20Law%20LLP%20website%20enquiry'; 
	
};


function emailmeCifti(sFN) {
	window.location = 'mailto:' + sFN + '?subject=CE%20Partners%20website%20enquiry'; 
		
};


function emailmegeneral(sFN){
	window.location = 'mailto:' + sFN + '?subject=Website%20enquiry';
};

// -------------------------------------------------------------------------------------
// Pre-select find people menu
// -------------------------------------------------------------------------------------
	
function preselectFindPeopleSector(s) {
	
	var bFoundMatch = false;

	$('form#form_findpeople fieldset#fieldset_home_2_sector option').each( function() {
		if ($(this).text().toLowerCase() == s.toLowerCase()) {
			$(this).attr('selected', 'selected');
			bFoundMatch = true;
		}
	});
	
	return(bFoundMatch);
	
};

function preselectFindPeopleOffice(s) {

	var bFoundMatch = false;

	$('form#form_findpeople fieldset#fieldset_home_2_jurisdiction option').each( function() {
		if ($(this).text().toLowerCase() == s.toLowerCase()) {
			$(this).attr('selected', 'selected');
			bFoundMatch = true;
		}
	});
};

// -------------------------------------------------------------------------------------
// Control the TKOSP Bar
// -------------------------------------------------------------------------------------
	
function openCloseTKOSPOriginal() {

    alert('openCloseTKOSP');

	var nMaxHeight = $('section#section_tkosp').data('maxheight');

    alert(nMaxHeight);

	if ($('section#section_tkosp').css('top') == '-' + nMaxHeight + 'px') {
		$('section#section_tkosp').animate({'top': '0px'});
		$('body').animate({'padding-top': nMaxHeight + 'px'});
		$('a#a_tkosp_button').animate({'background-position-y': '-28px'});
	} else {
		$('section#section_tkosp').animate({'top': '-' + nMaxHeight + 'px'});
		$('body').animate({'padding-top': '15px'});
		$('a#a_tkosp_button').animate({'background-position-y': '5px'});
	}

};