<?php
include ("view/template.php");

class Media extends Template
{
    function __construct ()
    {
        parent::__construct ("media", "Media Centre", "Latest News & Information");
    }

    function printMainContent()
    {
    ?>
    <div class="full_width">
        <section id="section_main" class="page_container">
            <div class="iparsysmain iparsys parsys">
                <div class="section"><div class="new"></div>
            </div>
            <div class="iparys_inherited">
                <div class="iparsysmain iparsys parsys"></div>
            </div>        
            <div class="body_container">
                <div class="leftNav">
                    <a class="a_show_nav_secondary">In this section</a>
                    <nav id="nav_secondary">
                        <ul>
                            <li>
                                <a href="about_us.php" class="unselected">                                
                                    Who we are and how we work
                                </a>
                            </li>
                            <li>
                                <a href="business.php" class="unselected">
                                    Responsible Business
                                </a>
                            </li>
                            <li>
                                <a href="expertise.php" class="unselected">
                                    Inclusion &amp; diversity
                                </a>               
                            </li>
                            <li>
                                <a href="#" class="selected">            
                                    Media centre
                                </a>        
                                <ul style="">        
                                    <li>
                                        <a href="#" class="unselected">         
                                            Social Media
                                        </a>
                                    </li>            
                                    <li>
                                        <a href="#" class="unselected">      
                                            News
                                        </a>
                                    </li>
                                    <li>
                                        <a href="#" class="unselected">
                                            Regional media contacts
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </nav>
                </div>
                <article id="article_main">
                    <a name="startcontent" id="startcontent"></a>
                    <div class="pageHeader userToolbar">
                        <header>
                            <a href="#" id="a_main_content" title="Start of main content">Start of main content</a>
                            <h2>Media centre</h2>
                        </header>
                    </div>
                    <div class="parCenter parsys">
                        <div class="latestNews section">
                            <h3 class="contentTitle">Latest news</h3>
                            <ul class="seperateitems ul_latest_news">
                                <li>
                                    <strong>Client Work</strong><br>
                                    <span class="pageColour_text">13 August 2025</span>
                                    <a href="media.php" title="Yonga & Simiyu vertritt INTEGRITAS erfolgreich in Verfahren gegen Produkte sowie hunderte Werbeaussagen und Kennzeichnungsverstöße im Bereich gewichtskontrollierender Ernährung">Yonga & Simiyu vertritt INTEGRITAS erfolgreich in Verfahren gegen Produkte sowie hunderte Werbeaussagen und Kennzeichnungsverstöße im Bereich gewichtskontrollierender Ernährung</a>
                                </li>
                                <li>
                                    <strong>Client Work</strong><br>
                                    <span class="pageColour_text">12 August 2025</span>
                                    <a href="#" title="Yonga & Simiyu vertritt INTEGRITAS erfolgreich in Verfahren gegen Produkte sowie hunderte Werbeaussagen und Kennzeichnungsverstöße im Bereich gewichtskontrollierender Ernährung">Yonga & Simiyu vertritt INTEGRITAS erfolgreich in Verfahren gegen Produkte sowie hunderte Werbeaussagen und Kennzeichnungsverstöße im Bereich gewichtskontrollierender Ernährung</a>
                                </li>
                                <li>
                                    <strong>Client Work</strong><br>
                                    <span class="pageColour_text">11 August 2025</span>
                                    <a href="#" title="Yonga & Simiyu vertritt INTEGRITAS erfolgreich in Verfahren gegen Produkte sowie hunderte Werbeaussagen und Kennzeichnungsverstöße im Bereich gewichtskontrollierender Ernährung">Yonga & Simiyu vertritt INTEGRITAS erfolgreich in Verfahren gegen Produkte sowie hunderte Werbeaussagen und Kennzeichnungsverstöße im Bereich gewichtskontrollierender Ernährung</a>
                                </li>
                                <li>
                                    <strong>Press Release</strong><br>
                                    <span class="pageColour_text">8 August 2025</span>
                                    <a href="#" title="Yonga & Simiyu vertritt INTEGRITAS erfolgreich in Verfahren gegen Produkte sowie hunderte Werbeaussagen und Kennzeichnungsverstöße im Bereich gewichtskontrollierender Ernährung">Yonga & Simiyu vertritt INTEGRITAS erfolgreich in Verfahren gegen Produkte sowie hunderte Werbeaussagen und Kennzeichnungsverstöße im Bereich gewichtskontrollierender Ernährung</a>
                                </li>
                                <li>
                                    <strong>Press Release</strong><br>
                                    <span class="pageColour_text">8 August 2025</span>
                                    <a href="#" title="Yonga & Simiyu vertritt INTEGRITAS erfolgreich in Verfahren gegen Produkte sowie hunderte Werbeaussagen und Kennzeichnungsverstöße im Bereich gewichtskontrollierender Ernährung">Yonga & Simiyu vertritt INTEGRITAS erfolgreich in Verfahren gegen Produkte sowie hunderte Werbeaussagen und Kennzeichnungsverstöße im Bereich gewichtskontrollierender Ernährung</a>
                                </li>
                            </ul>
                            <a class="morelink arrow_right space_before_10" href="#" title="More news releases">More news releases</a>
                        </div>
                    </div>
                </article>
                <?php $this->printShareShow(); ?>
                <aside id="aside_main">
                    <div class="parRight parsys">
                        <div class="imageAndTextLink section">
                            <div class="a_image_text_link_pod">
                                <h2 style="padding-left: 10px !important;">E. A. Region Media Contacts</h2>
                                <p>View a list of our regional media contacts</p>
                            </div>
                        </div>
                        <div class="followUs section">
                            <ul class="ul_follow">
                                <li class="li_follow">
                                    <ul class="pageColour_bg">
                                        <li class="li_follow_linkedin"><a href="https://www.linkedin.com/company/yongaandsimiyuadvocates" target="_blank">on LinkedIn</a></li>
                                        <li class="li_follow_instagram"><a href="https://www.instagram.com/yongaandsimiyuadvocates" target="_blank">on Instagram</a></li>
                                        <li class="li_follow_youtube"><a href="https://www.youtube.com/channel/yongaandsimiyuadvocates" target="_blank">on Youtube</a></li>
                                    </ul>
                                    <span class="pageColour_bg">Follow us</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </aside>
                <!-- Script for Schema markup -->
                <script>

                let text = document.location.href;
                let result = text.substring(text.indexOf('.com')+5,text.indexOf('.php'));
                console.log(result);
                const nameArr = result.split("/").reverse();
                console.log(nameArr);
                var indices = [];
                for(var i=0; i<result.length;i++) {
                    if (result[i] === "/") indices.push(i);
                }
                var revIndices=indices.reverse();
                var itemArr=[];
                itemArr.push(text);
                for(var i=0; i<indices.length;i++) {
                    itemArr.push(document.location.protocol +"//"+document.location.host+"/"+result.substring(0,revIndices[i])+'.html');
                }
                console.log(itemArr);                    
                    var bschema = {
                        "@context": "https://schema.org/", 
                        "@type": "BreadcrumbList", 
                        "itemListElement": []
                    }   
                    for(var i=0; i<nameArr.length; i++)  {
                        bschema.itemListElement.push({"@type":"ListItem","position":i, "name":nameArr[i], "item": itemArr[i]});
                    }
                    var bscript = document.createElement('script');
                        bscript.type = "application/ld+json";
                        bscript.text = JSON.stringify(bschema);
                        document.querySelector('head').appendChild(bscript);

                </script>
                <!-- Script for Schema markup end -->
            </div>
        </section>
    </div>
    <?php
    }

    function printPageStyle ()
    {
    ?>
    <style type="text/css">
        .pageColour_text {
        color: #a56c02 !important;
        }

        .pageColour_bg {
        background-color: #a56c02 !important;
        }

        header#header_main_microsite nav#nav_primary > ul > li.selected {
        background-image: url(/etc/designs/cc2014/images/dynamic-microsite/FF6200_arrow.png);
        }

        @media only screen and (-webkit-min-device-pixel-ratio: 1.5), only screen and (-o-min-device-pixel-ratio: 3/2), only screen and (min--moz-device-pixel-ratio: 1.5), only screen and (max-width: 480px), only screen and (min-device-pixel-ratio: 1.5) {
            header#header_main_microsite nav#nav_primary > ul > li.selected {
                background-image: url(/etc/designs/cc2014/images/dynamic-microsite/FF6200_arrow@2x.png);
            }
        }
    </style>
    <?php
    }
}
$media = new Media;
$media->printPage();
?>